<?xml version="1.0" encoding="iso-8859-1"?>
<!--
  Copyright 1999-2004 The Apache Software Foundation

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
-->

<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:search="http://apache.org/cocoon/search/1.0"
>
<xsl:param name="upnode"/>
<xsl:param name="path"/>
<xsl:param name="queryString"/>

  <xsl:template match="search:results">
   <results>
        <div id="doc-title">Rsultat de la recherche : <xsl:value-of select="$queryString"/></div>
        <div class="doc-element">Rsum</div>
        <xsl:choose>
            <xsl:when test="search:hits/@total-count=0">
		 <p>Aucun document trouv.</p>
                 <p>Voulez-vous effectuer une <a href="advsearch?path={$path}">recherche avance</a>?</p>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates/>
            </xsl:otherwise>
        </xsl:choose>
        <div class="doc-element">Search Help</div>
        <table cellspacing="2" cellpadding="2">
          <tr valign="top">
          <td width="50%"><font size="-2" >
            <ul>
              <li>free AND "text search"
                Search for documents containing "free" and the 
                phrase "text search"
              </li>
              <li>+text search
                Search for documents containing "text" and 
                preferentially containing "search".
              </li>
              <li>giants -football
                Search for "giants" but omit documents containing "football"
              </li>
            </ul>
          </font></td></tr>
          <tr valign="top">
          <td><font size="-2">
            <ul>
              <li>body:john
                Search for documents containing "john" in the  body field.
                The field "body" is used by default.
                Thus query "body:john" is equivalent to query "john".
              </li>
              <li>s1@title:cocoon
                Search for documents containing "cocoon" in the
                using field s1@title, ie searching in
                title attribute of s1 element of xml document.
              </li>
            </ul>
          </font></td>
          </tr>
        </table>
	
     </results> 
   </xsl:template>

  <xsl:template match="search:hits">
    <p>
       <xsl:choose>
      	<xsl:when test="@total-count &gt; 1">- Documents trouvs : <xsl:value-of select="@total-count"/>.</xsl:when>
	<xsl:otherwise> 1 seul document trouv.</xsl:otherwise>
      </xsl:choose>
      
      <br/>
      - <xsl:value-of select="@count-of-pages"/>
      <xsl:choose>
      	<xsl:when test="@count-of-pages &gt; 1"> pages.</xsl:when>
	<xsl:otherwise> page.</xsl:otherwise>
      </xsl:choose>
	
	
    </p>
    <div class="doc-element">Classement</div>
    <p>
    <xsl:call-template name="navigation-paging-link">
      <xsl:with-param name="query-string" select="/search:results/@query-string"/>
      <xsl:with-param name="page-length" select="/search:results/@page-length"/>
      <xsl:with-param name="has-previous" select="/search:results/search:navigation/@has-previous"/>
      <xsl:with-param name="has-next" select="/search:results/search:navigation/@has-next"/>
      <xsl:with-param name="previous-index" select="/search:results/search:navigation/@previous-index"/>
      <xsl:with-param name="next-index" select="/search:results/search:navigation/@next-index"/>
    </xsl:call-template>
    </p>
    <hr/>
    
    <table id="search-result-tab">
      <tr>
        <td>Score</td><td>Rang</td><td>Document</td>
      </tr>
      <xsl:apply-templates/>
    </table>
     <p>
      Page:
      <xsl:for-each select="/search:results/search:navigation/search:navigation-page">
        <xsl:call-template name="navigation-link"> 
          <xsl:with-param name="query-string" select="/search:results/@query-string"/>
          <xsl:with-param name="page-length" select="/search:results/@page-length"/>
          <xsl:with-param name="start-index" select="@start-index"/>
          <xsl:with-param name="link-text" select="position()"/>
        </xsl:call-template>
      </xsl:for-each>
    </p>
  </xsl:template>

  <xsl:template match="search:navigation">
    <p>
    <xsl:call-template name="navigation-paging-form">
      <xsl:with-param name="query-string"><xsl:value-of select="/search:results/@query-string"/></xsl:with-param>
      <xsl:with-param name="page-length"><xsl:value-of select="/search:results/@page-length"/></xsl:with-param>
      <xsl:with-param name="has-previous"><xsl:value-of select="@has-previous"/></xsl:with-param>
      <xsl:with-param name="has-next"><xsl:value-of select="@has-next"/></xsl:with-param>
      <xsl:with-param name="previous-index"><xsl:value-of select="@previous-index"/></xsl:with-param>
      <xsl:with-param name="next-index"><xsl:value-of select="@next-index"/></xsl:with-param>
    </xsl:call-template>
    </p>
  </xsl:template>
  
  <xsl:template match="search:hit">
    <tr>
      <td>
        <xsl:value-of select="format-number( @score, '### %' )"/>
      </td>
      <td>
        <xsl:value-of select="@rank"/>
      </td>
      <td>
        <!-- important : file doit tre le dernier paramtre pass dans l'uri (dpends de content2lucene.xsl)-->
	<xsl:variable name="injac-file" select="substring-after(@uri, 'file=')"/>
	<xsl:variable name="injac-path" select="substring-before(substring-after(@uri, $upnode), concat('/',$injac-file))"/>
	<xsl:variable name="title" select="substring-before(substring-after(@uri, 'title='), '&amp;')"/>
	<xsl:variable name="displayname">
		<xsl:choose>
			<xsl:when test="$title != ''">
				<xsl:value-of select="$title"/>	
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$injac-file"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<!-- lien vers un document en interne -->
        <!--li class="file"><a class="file" href="./?path={$injac-path}&amp;file={$injac-file}" -->
        <li class="file"><a class="file" href="./?path={$injac-path}&amp;doc=/{$injac-file}" >
          <xsl:value-of select="$displayname"/>
        </a></li>
      </td>
    </tr>
  </xsl:template>

  <xsl:template name="navigation-paging-form">
    <xsl:param name="query-string"/>
    <xsl:param name="page-length"/>
    <xsl:param name="has-previous"/>
    <xsl:param name="has-next"/>
    <xsl:param name="previous-index"/>
    <xsl:param name="next-index"/>

    <xsl:if test="$has-previous = 'true'">
      <form action="search">
        <input type="hidden" name="startIndex" value="{$previous-index}"/>
        <input type="hidden" name="queryString" value="{$query-string}"/>
        <input type="hidden" name="pageLength" value="{$page-length}"/>
	<input type="hidden" name="path" value="{$path}"/>
        <input type="submit" name="previous" value="previous"/>
      </form>
    </xsl:if>
    
    <xsl:if test="$has-next = 'true'">
      <form action="search">
        <input type="hidden" name="startIndex" value="{$next-index}"/>
        <input type="hidden" name="queryString" value="{$query-string}"/>
        <input type="hidden" name="pageLength" value="{$page-length}"/>
	<input type="hidden" name="path" value="{$path}"/>
        <input type="submit" name="next" value="next"/>
      </form>
    </xsl:if>
    
  </xsl:template>

  <xsl:template name="navigation-paging-link">
    <xsl:param name="query-string"/>
    <xsl:param name="page-length"/>
    <xsl:param name="has-previous"/>
    <xsl:param name="has-next"/>
    <xsl:param name="previous-index"/>
    <xsl:param name="next-index"/>

    <xsl:if test="$has-previous = 'true'">
      
      <xsl:call-template name="navigation-link">
        <xsl:with-param name="query-string"><xsl:value-of select="$query-string"/></xsl:with-param>
        <xsl:with-param name="page-length"><xsl:value-of select="$page-length"/></xsl:with-param>
        <xsl:with-param name="start-index"><xsl:value-of select="$previous-index"/></xsl:with-param>
        <xsl:with-param name="link-text">Previous Page Of Hits</xsl:with-param>
      </xsl:call-template>
    </xsl:if>
    &#160;
    <xsl:if test="$has-next = 'true'">
      <a href="search?startIndex={$next-index}&amp;queryString={$query-string}&amp;pageLength={$page-length}&amp;path={$path}">
        Next Page Of Hits
      </a>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="navigation-link">
    <xsl:param name="query-string"/>
    <xsl:param name="page-length"/>
    <xsl:param name="start-index"/>
    <xsl:param name="link-text"/>

    <a href="search?startIndex={$start-index}&amp;queryString={$query-string}&amp;pageLength={$page-length}&amp;path={$path}">
      <xsl:value-of select="$link-text"/>
    </a>
    &#160;
  </xsl:template>

  <xsl:template match="@*|node()" priority="-2"><xsl:copy><xsl:apply-templates select="@*|node()"/></xsl:copy></xsl:template>
  <xsl:template match="text()" priority="-1"><xsl:value-of select="."/></xsl:template>

</xsl:stylesheet>

